/**
 * Created by lei.wang_1 on 2017/1/9.
 */
appModule.directive("insertVideoPanel", ["$translate", function (translate) {
    return {
        template: `<article class="videoPanel" ng-show="isShow">
                    <div class="videoContent">
                        <section class="header">
                            <div class="title" translate="publish.editor.video.insert-video"></div>
                            <page-icons only-close="true" on-close="init();onCancel();"></page-icons>
                        </section>
                        <section class="inputs">
                            <input type="url" ng-model="url" placeholder="{{'publish.editor.video.url-placeholder'|translate}}"/>
                            <text-limit max="maxNamelength" target="name"></text-limit>
                            <input type="text" class="name" ng-model="name" placeholder="{{'publish.editor.video.name-placeholder'|translate}}"/>
                        </section>
                        <section class="footer">
                            <label translate="publish.editor.video.tooltip"></label>
                            <button class="btn darkBtn" translate="common.complete" ng-click="finish()" ng-class="{'disabled':!canFinish()}"></button>
                        </section>
                    </div>
                 </article>`,
        restrict: "E",
        replace: true,
        scope: {
            onCancel: "&",
            onComplete: "&",
            isShow: "="
        },
        link: function ($scope) {
            $scope.maxNamelength=30;
            $scope.init = function(){
                $scope.url = '';
                $scope.name = '';
            };

            $scope.canFinish = function(){
                return $scope.url && (!$scope.name || $scope.name && $scope.name.length <= $scope.maxNamelength);
            };

            $scope.finish = function () {
                if($scope.canFinish()){
                    var name = $scope.name || '';
                    var url = $scope.url;
                    if (url && $scope.onComplete) {
                        $scope.onComplete({
                            url:url,
                            name:name
                        });
                        $scope.init();
                        if($scope.onCancel){
                            $scope.onCancel();
                        }
                    }
                }
            };
        }
    };
}]);